using System;
using System.Linq;
using System.Collections.Generic;

class Solution {
    static int n;
    static List<OneWayRoad>[] roadsToCities;
    public static void Main(string[] args) {
        //data
        string[] data = Console.ReadLine().Split(' ');
        n = Convert.ToInt32(data[0]); //n cities
        int m = Convert.ToInt32(data[1]); //m roads

        //list of roads
        List<OneWayRoad> roads = new List<OneWayRoad>();
        for (int i = 0; i < m; i++)
        {
            data = Console.ReadLine().Split(' ');
            int FromCityIndex = Convert.ToInt32(data[0]);
            int ToCityIndex = Convert.ToInt32(data[1]);
            roads.Add(new OneWayRoad(FromCityIndex, ToCityIndex));
        }

        //connectRoadsToCities
        roadsToCities = new List<OneWayRoad>[n];
        for(int i = 0; i < n; i++)
        {
            roadsToCities[i] = new List<OneWayRoad>();
        }
        foreach(OneWayRoad road in roads)
        {
            roadsToCities[road.fromCityIndex - 1].Add(road);
        }

        //solution
        (bool isSolved, int[] visited) = IsPerfectLoop(1, new List<int>(), roads);
        Console.WriteLine( isSolved ? "YES" : "NO");
        if (isSolved)
        {
            foreach(int a in visited)
                Console.Write($"{a} ");
        }
    }
    static (bool, int[]) IsPerfectLoop(int currentCityIndex, List<int> indexesOfCitiesVisited, List<OneWayRoad> roads)
    {
        //base variant
        if (indexesOfCitiesVisited.Contains(currentCityIndex))
        {
            indexesOfCitiesVisited.Add(currentCityIndex); //add this city again, needed in answer
            bool result = (indexesOfCitiesVisited.Count == n + 1) && (currentCityIndex == 1);

            //debug
            //Console.WriteLine($"Base variant: number test {(indexesOfCitiesVisited.Count == n + 1)} index test {(currentCityIndex == 1)} citiesvisited {indexesOfCitiesVisited.Count}; result: {result}");
            //foreach (int a in indexesOfCitiesVisited)
            //{
            //    Console.Write(a);
            //}
            //Console.WriteLine();

            return (result, indexesOfCitiesVisited.ToArray()); //are there all the cities? did it return back to the 1st one?
        }

        //not base variant
        int[] visited = new int[] { };
        bool isPerfect = false;
        foreach (OneWayRoad road in roadsToCities[currentCityIndex - 1])
        {
            if (road.fromCityIndex == currentCityIndex)
            {
                List<int> newCitiesVisited = new List<int>(indexesOfCitiesVisited);
                newCitiesVisited.Add(currentCityIndex);
                (isPerfect, visited) = IsPerfectLoop(road.toCityIndex, newCitiesVisited, roads);
                if (isPerfect)
                {
                    break;
                }
            }
        }
        return (isPerfect, visited); //will be true if any variant returned true
    }
    struct OneWayRoad
    {
        public int fromCityIndex;
        public int toCityIndex;
        public OneWayRoad(int a, int b)
        {
            fromCityIndex = a; //from
            toCityIndex = b; //to
        }
    }
}
